﻿
/****************************************************************************/
/*Copyright (c) 2011, Florent DEVILLE.                                      */
/*All rights reserved.                                                      */
/*                                                                          */
/*Redistribution and use in source and binary forms, with or without        */
/*modification, are permitted provided that the following conditions        */
/*are met:                                                                  */
/*                                                                          */
/* - Redistributions of source code must retain the above copyright         */
/*notice, this list of conditions and the following disclaimer.             */
/* - Redistributions in binary form must reproduce the above                */
/*copyright notice, this list of conditions and the following               */
/*disclaimer in the documentation and/or other materials provided           */
/*with the distribution.                                                    */
/* - The names of its contributors cannot be used to endorse or promote     */
/*products derived from this software without specific prior written        */
/*permission.                                                               */
/* - The source code cannot be used for commercial purposes without         */
/*its contributors' permission.                                             */
/*                                                                          */
/*THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT         */
/*LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS         */
/*FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE            */
/*COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,       */
/*INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,      */
/*BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;          */
/*LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER          */
/*CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT        */
/*LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN         */
/*ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE           */
/*POSSIBILITY OF SUCH DAMAGE.                                               */
/****************************************************************************/

using System.Collections.Generic;
using System.Xml;

using GE.Tools;

namespace GE.Tools
{
    /// <summary>
    /// Manages languages.
    /// </summary>
    class Localization
    {
        /// <summary>
        /// Node name in the XML file.
        /// </summary>
        private const string NODE_NAME = "string";

        /// <summary>
        /// Key name in the XML file.
        /// </summary>
        private const string KEY_NAME = "key";

        /// <summary>
        /// Value name in the XML file.
        /// </summary>
        private const string VALUE_NAME = "value";

        /// <summary>
        /// Unique instance of the Localization class.
        /// </summary>
        private static Localization m_instance = new Localization();

        /// <summary>
        /// Likns keys to translated strings.
        /// </summary>
        private Dictionary<string, string> m_table;

        /// <summary>
        /// Unique instance of the Localization class.
        /// </summary>
        public static Localization Instance
        {
            get { return m_instance; }
        }

        /// <summary>
        /// Private Contructor.
        /// </summary>
        private Localization()
        {
            m_table = new Dictionary<string, string>();
        }

        /// <summary>
        /// Initializes the Localizion component.
        /// </summary>
        /// <param name="filename">language file</param>
        /// <returns>false if a problem occured</returns>
        public bool init(string filename)
        {
            m_table.Clear(); // in case of re-init

            XmlDocument doc = new XmlDocument();

            try
            {
                doc.Load(filename);
            }
            catch
            {
                return false;
            }

            XmlElement localization = doc.DocumentElement;
            XmlNodeList strings = localization.GetElementsByTagName(NODE_NAME);

            m_table.Clear(); // in case of language change
            foreach (XmlNode node in strings)
                m_table[node.Attributes[KEY_NAME].Value] = node.Attributes[VALUE_NAME].Value;

            return true;
        }

        /// <summary>
        /// Get a translated string.
        /// </summary>
        /// <param name="id">key</param>
        /// <returns>translated string, "**ERROR**" if an error occured</returns>
        public string getString(string id)
        {
            if(m_table.ContainsKey(id))
                return m_table[id];
            return "**ERROR**";
        }
    }
}
